/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.tools.integration.jei;

import dev.ftb.ftbsbc.tools.ToolsRegistry;
import dev.ftb.ftbsbc.tools.integration.jei.CauldronCategory;
import dev.ftb.ftbsbc.tools.integration.jei.CrookCategory;
import dev.ftb.ftbsbc.tools.integration.jei.HammerCategory;
import dev.ftb.ftbsbc.tools.recipies.NoInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation FTBSBTOOLS_JEI = new ResourceLocation("ftbsbc", "jei");
    public static HashSet<RegistryObject<? extends Item>> HAMMERS = new LinkedHashSet<RegistryObject<? extends Item>>(){
        {
            this.add(ToolsRegistry.STONE_HAMMER);
            this.add(ToolsRegistry.IRON_HAMMER);
            this.add(ToolsRegistry.GOLD_HAMMER);
            this.add(ToolsRegistry.DIAMOND_HAMMER);
            this.add(ToolsRegistry.NETHERITE_HAMMER);
            this.add(ToolsRegistry.IRON_AUTO_HAMMER_BLOCK_ITEM);
            this.add(ToolsRegistry.GOLD_AUTO_HAMMER_BLOCK_ITEM);
            this.add(ToolsRegistry.DIAMOND_AUTO_HAMMER_BLOCK_ITEM);
            this.add(ToolsRegistry.NETHERITE_AUTO_HAMMER_BLOCK_ITEM);
        }
    };
    public static HashSet<RegistryObject<Item>> CROOKS = new HashSet<RegistryObject<Item>>(){
        {
            this.add(ToolsRegistry.CROOK);
        }
    };

    public ResourceLocation getPluginUid() {
        return FTBSBTOOLS_JEI;
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        r.addRecipeCategories(new IRecipeCategory[]{new HammerCategory(r.getJeiHelpers().getGuiHelper())});
        r.addRecipeCategories(new IRecipeCategory[]{new CrookCategory(r.getJeiHelpers().getGuiHelper())});
        r.addRecipeCategories(new IRecipeCategory[]{new CauldronCategory(r.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration r) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        r.addRecipes((Collection)level.m_7465_().m_44056_((RecipeType)ToolsRegistry.HAMMER_RECIPE_TYPE.get(), (Container)NoInventory.INSTANCE, (Level)level), HammerCategory.ID);
        r.addRecipes((Collection)level.m_7465_().m_44056_((RecipeType)ToolsRegistry.CROOK_RECIPE_TYPE.get(), (Container)NoInventory.INSTANCE, (Level)level), CrookCategory.ID);
        FluidStack out = new FluidStack((Fluid)Fluids.f_76193_, 333);
        ArrayList<ItemStack> leaves = new ArrayList<ItemStack>();
        ArrayList<ItemStack> saplings = new ArrayList<ItemStack>();
        for (Block block : ForgeRegistries.BLOCKS) {
            Item item;
            if (block instanceof LeavesBlock) {
                item = block.m_5456_();
                if (item == Items.f_41852_) continue;
                leaves.add(item.m_7968_());
                continue;
            }
            if (!(block instanceof SaplingBlock) || (item = block.m_5456_()) == Items.f_41852_) continue;
            saplings.add(item.m_7968_());
        }
        r.addRecipes(Arrays.asList(new CauldronCategory.CauldronRecipe(leaves, out), new CauldronCategory.CauldronRecipe(saplings, out)), CauldronCategory.UID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        r.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42544_), new ResourceLocation[]{CauldronCategory.UID});
        HAMMERS.forEach(hammer -> r.addRecipeCatalyst(new ItemStack((ItemLike)hammer.get()), new ResourceLocation[]{HammerCategory.ID}));
        CROOKS.forEach(crook -> r.addRecipeCatalyst(new ItemStack((ItemLike)crook.get()), new ResourceLocation[]{CrookCategory.ID}));
    }
}

